<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Medicine Search</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background-color: #f4f9fb;
            margin: 0;
            padding: 0;
            color: #333;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .container {
            max-width: 800px;
            margin: 40px auto;
            padding: 20px;
            background-color: white;
            border-left: 5px solid #00bcd4;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        h2 {
            text-align: center;
            color: #0097a7;
        }

        form {
            display: grid;
            grid-template-columns: auto auto;
            gap: 15px 20px;
            padding: 20px;
        }

        form label {
            font-weight: bold;
            color: #00796b;
        }

        form input[type="text"],
        form input[type="number"] {
            padding: 10px;
            border: 2px solid #00bcd4;
            border-radius: 6px;
            font-size: 16px;
        }

        form button[type="button"] {
            background-color: #00bcd4;
            color: white;
            border: none;
            padding: 12px;
            font-size: 16px;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            grid-column: 1 / 3; /* Submit button spans both columns */
        }

        form button[type="button"]:hover {
            background-color: #0097a7;
        }

        .results {
            margin-top: 30px;
            padding: 15px;
            background-color: #e0f7fa;
            border-radius: 10px;
        }

        .results p {
            margin: 8px 0;
            padding: 10px;
            background-color: white;
            border-left: 4px solid #00bcd4;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
            border-radius: 5px;
        }

        .back-home {
            margin-top: 20px;
        }

        .back-home a {
            text-decoration: none;
            background-color: #4caf50;
            color: white;
            padding: 10px 15px;
            border-radius: 8px;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        .back-home a:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Medicine Search</h2>

    <form id="searchForm">
        <label for="name">Medicine Name:</label>
        <input type="text" id="name" name="name" placeholder="eg.Paracetamol">

        <label for="qty">Quantity:</label>
        <input type="number" id="qty" name="qty" placeholder="eg.10" min="1">

        <label for="location">Location:</label>
        <input type="text" id="location" name="location" placeholder="eg.Chennai">

        <button type="button" onclick="filterMedicines()">Search</button>
    </form>

    <div class="results" id="searchResults">
        </div>

    <div class="back-home">
        <a href="/home">Back to Home</a>
    </div>
</div>

<script>
    // மாதிரி மருந்து தரவு (உண்மையான பயன்பாட்டில் இது சேவையகத்திலிருந்து வரும்)
    const allMedicines = [
        { name: "Paracetamol", quantity: 10, shop: "Apollo Pharmacy", location: "Chennai" },
        { name: "Amoxicillin", quantity: 5, shop: "MedPlus", location: "Chennai" },
        { name: "Paracetamol", quantity: 20, shop: "Generic Store", location: "Madurai" },
        { name: "Cetirizine", quantity: 15, shop: "Apollo Pharmacy", location: "Coimbatore" },
        { name: "Amoxicillin", quantity: 8, shop: "City Medical", location: "Madurai" },
        { name: "Paracetamol", quantity: 12, shop: "Orange Meds", location: "Chennai" }
    ];

    function filterMedicines() {
        const nameInput = document.getElementById("name").value.toLowerCase();
        const qtyInput = parseInt(document.getElementById("qty").value);
        const locationInput = document.getElementById("location").value.toLowerCase();
        const searchResultsDiv = document.getElementById("searchResults");
        searchResultsDiv.innerHTML = "";

        console.log("Input Name:", nameInput);
        console.log("Input Quantity:", qtyInput);
        console.log("Input Location:", locationInput);

        const filteredMedicines = allMedicines.filter(medicine => {
            const nameMatch = medicine.name.toLowerCase().includes(nameInput);
            const qtyMatch = medicine.quantity >= qtyInput;
            const locationMatch = medicine.location.toLowerCase().includes(locationInput);
            console.log("Checking:", medicine.name, "Name Match:", nameMatch, "Qty Match:", qtyMatch, "Location Match:", locationMatch);
            return nameMatch && qtyMatch && locationMatch;
        });

        console.log("Filtered Medicines:", filteredMedicines);

        if (filteredMedicines.length > 0) {
            filteredMedicines.forEach(medicine => {
                const medicinePara = document.createElement("p");
                medicinePara.textContent = `${medicine.name} - Qty: ${medicine.quantity} - Shop: ${medicine.shop} - Location: ${medicine.location}`;
                searchResultsDiv.appendChild(medicinePara);
            });
        } else {
            searchResultsDiv.innerHTML = "<p>No medicines found matching your criteria.</p>";
        }
    }

    // பக்கம் ஏற்றப்பட்டவுடன் அனைத்து மருந்துகளையும் காட்ட விரும்பினால்:
    // window.onload = filterMedicines;
</script>

</body>
</html>