<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %> <%-- JSTL taglib added --%>
<%@ taglib uri="jakarta.tags.functions" prefix="fn" %>


<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>New Insurance Plans</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            background-color: #f4f8fb;
        }

        header {
            background-color: #007BFF;
            color: white;
            padding: 20px;
            text-align: center;
        }

        nav {
            background-color: #e9ecef;
            padding: 10px;
            text-align: center;
        }

        nav a {
            margin: 0 15px;
            text-decoration: none;
            color: #007BFF;
            font-weight: bold;
        }

        nav a:hover {
            text-decoration: underline;
        }

        .container {
            max-width: 900px;
            margin: 40px auto;
            background-color: white;
            padding: 30px 40px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 30px;
        }

        ul {
            list-style: none;
            padding: 0;
        }

        li {
            background-color: #f9f9f9;
            padding: 25px;
            border: 1px solid #ddd;
            border-radius: 10px;
            margin-bottom: 20px;
            transition: transform 0.2s;
        }

        li:hover {
            transform: scale(1.02);
            box-shadow: 0 6px 18px rgba(0, 123, 255, 0.1);
        }

        h3 {
            margin-top: 0;
            color: #007BFF;
        }

        p {
            margin: 6px 0;
            color: #444;
        }

        a.buy-link {
            display: inline-block;
            margin-top: 10px;
            padding: 10px 18px;
            background-color: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
        }

        a.buy-link:hover {
            background-color: #218838;
        }

        .no-plans-message {
            text-align: center;
            color: #777;
            font-style: italic;
            margin-top: 30px;
            padding: 20px;
            border: 1px dashed #ccc;
            border-radius: 8px;
        }

        footer {
            text-align: center;
            padding: 15px;
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>

    <header>
        <h1>New Insurance Plans</h1>
    </header>

    <nav>
        <a href="medicalInsurance">Back to Medical Insurance</a>
        <a href="home">Home</a>
        <a href="logout">Logout</a>
    </nav>

    <div class="container">
        <h2>Available Insurance Plans</h2>

        <%-- Check if the 'insurancePlans' list is empty --%>
        <c:if test="${empty insurancePlans}">
            <p class="no-plans-message">No insurance plans are currently available. Please check back later!</p>
        </c:if>

        <%-- If 'insurancePlans' list is not empty, iterate and display them --%>
        <c:if test="${not empty insurancePlans}">
            <ul>
                <c:forEach var="plan" items="${insurancePlans}">
                    <li>
                        <h3><c:out value="${plan.name}"/></h3>
                        <p><strong>Coverage:</strong> ₹<c:out value="${plan.coverage}"/></p>
                        <p><strong>Premium:</strong> ₹<c:out value="${plan.amountPerYear}"/>/year</p>
                        <%-- Assuming 'amountPerYear' is the value needed for the payment gateway --%>
                        <%-- 
                        <a class="buy-link" href="/buyInsuranceDetails?planName=<c:out value="${plan.name}"/>&coverage=<c:out value="${plan.coverage}"/>&premium=<c:out value="${plan.amountPerYear}"/>&boughtInsuranceId=<c:out value="${plan.id}"/>">Buy Plan</a>
                         --%>
                        <%--   
                         <a class="buy-link" href="/payment/generateInvoice?planName=<c:out value="${plan.name}"/>&coverage=<c:out value="${plan.coverage}"/>&premium=<c:out value="${plan.amountPerYear}"/>&boughtInsuranceId=<c:out value="${plan.id}"/>">Buy Plan</a>
                         --%>
                          
                       <a class="buy-link" href="/processBuy?planName=<c:out value="${plan.name}"/>&planId=<c:out value="${plan.id}"/>">Buy Plan</a>
                         
                        <!-- 
                        <a class="buy-link" href="/payment/generateInvoice">Buy Plan</a>
                         -->
                    </li>
                </c:forEach>
            </ul>
        </c:if>
    </div>

    <footer>
        &copy; 2025 Uniq Team FSD49 – All rights reserved.
    </footer>
</body>
</html>