<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Payment Successful!</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f2f7fa;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh; /* Full viewport height */
        }

        .container {
            max-width: 500px;
            background-color: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        h2 {
            color: #28a745; /* Green for success */
            margin-bottom: 25px;
            font-size: 2em;
        }

        .amount-display {
            font-size: 28px;
            font-weight: bold;
            color: #007bff;
            margin-bottom: 30px;
            padding: 15px;
            border: 1px solid #cceeff; /* Lighter blue border */
            border-radius: 8px;
            background-color: #eaf6ff;
            display: inline-block; /* To center the block */
        }

        p {
            color: #555;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        .button-link {
            display: inline-block;
            background-color: #007bff; /* Blue for home link */
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            text-decoration: none; /* Remove underline */
            transition: background-color 0.3s ease;
        }

        .button-link:hover {
            background-color: #0056b3;
        }
    </style>
    <script>
        window.onload = function() {
            // Automatically trigger invoice download
            window.location.href = '${pageContext.request.contextPath}/payment/generateInvoice?amount=<%= String.format("%.2f", amount) %>'; // Pass amount to invoice generation
            // After a short delay, redirect to the home page
            setTimeout(function() {
                window.location.href = '${pageContext.request.contextPath}/home'; // Adjust '/home' to your actual home page URL
            }, 3000); // Redirect after 3 seconds (gives time for download to initiate)
        };
    </script>
</head>
<body>

    <div class="container">
        <h2>Payment Successful!</h2>

        <%
            // URL இல் இருந்து 'amount' parameter-ஐப் பெறுகிறது
            String amountStr = request.getParameter("amount");
            double amount = 0.0;
            if (amountStr != null && !amountStr.isEmpty()) {
                try {
                    amount = Double.parseDouble(amountStr);
                } catch (NumberFormatException e) {
                    System.err.println("Invalid amount format: " + amountStr);
                }
            }
        %>

        <div class="amount-display">
            Amount Paid: ₹<%= String.format("%.2f", amount) %>
        </div>

        <p>Thank you for your payment. Your invoice is being generated and will download automatically.</p>
        <p>You will be redirected to the home page shortly.</p>

        <a href="${pageContext.request.contextPath}/home" class="button-link">Go to Home Page Now</a>
    </div>

</body>
</html>